<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Análise Financeira</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="./plugins/fontawesome-free/css/all.min.css?versao=3.2511.19.1">

  <!-- Theme style -->
  <link rel="stylesheet" href="./dist/css/adminlte.min.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="./dist/css/custom.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="./dist/css/sisplan.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="./dist/css/PesquisaVariosSelect2.css?versao=3.2511.19.1">
  <link rel="stylesheet" type="text/css" href="./plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2511.19.1">
  <!-- Toastr -->
  <link rel="stylesheet" href="./plugins/toastr/toastr.min.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="./plugins/fontawesome-free/css/all.min.css?versao=3.2511.19.1">
  <link rel="shortcut icon" href="./favicon.ico">
  <link rel="stylesheet" type="text/css" href="./dist/css/driver.min.css?versao=3.2511.19.1" />
  <link rel="stylesheet" href="./dist/css/jquery-ui.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="./plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="./plugins/select2/css/select2.min.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="./plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="./plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.2511.19.1">
  <link rel="stylesheet" type="text/css" href="./dist/css/sisplan.newColorsButtons.css?versao=3.2511.19.1" />
  <link rel="stylesheet" href="dist/css/sisplan.newColorsButtons.css?versao=3.2511.19.1" type="text/css" />


  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <style>
    .form-control:disabled,
    .form-control[readonly] {
      background-color: #f7f7f7;
      opacity: 1;
    }

    #msform {
      text-align: start;
      position: relative;
    }

    .card {
      box-shadow: none !important;
      border-radius: 0 !important;
      margin-bottom: 0 !important;
    }

    .card-header {
      box-shadow: 0px 1px rgb(0 0 0 / 20%) !important;
    }

    .card.card-header {
      border-bottom: 1px dashed #ddd;
      box-shadow: none !important;
    }

    .card-body {
      padding-left: 1.25rem !important;
      padding-top: 0px;
      padding-bottom: 0px;
      padding-right: 1.25rem !important;
    }

    .fa-angle-right,
    .fa-angle-down {
      color: #343a40;
    }

    .header-content-page .title-page,
    .title-content-page .title,
    .title-page {
      font-size: 20px;
      line-height: normal;
      font-weight: 500;
      color: var(--font-color);
      margin: 0;
      font-family: Roboto, Arial, sans-serif;
    }

    #btnRepresentante {
      background-color: #3ca2d3 !important;
    }

    #btnTransportadora {
      background-color: #5F9EA0 !important;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 1.0em 1.0em 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      border-radius: 3px !important;
    }

    #multiCollapseContábil {
      position: relative;
      z-index: 99999999;
    }

    td {
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
    }

    @media (max-width: 1194.8px) {
      .centralizaBotao {
        text-align: center;
      }
    }

    /* Estilo para telas maiores ou iguais a 992px (telas lg e maiores) */
    @media (min-width: 1195px) {
      .centralizaBotao {
        text-align: start;
      }
    }

    td.ColunaVermelha {
      color: red;
      font-weight: 600;
    }

    #lblRepresentantes:hover {
      cursor: pointer;
    }

    .valoresCard {
      display: flex;
      flex-direction: column;
      margin-left: 10px;
    }

    .inputInvisivel {
      border: none;
      color: var(--font-color);
      text-align: start;
      user-select: none;
      max-width: 100% !important;
      width: 100% !important;
    }

    .inputInvisivel:disabled {
      cursor: text;
    }

    .dados {
      height: 43px !important;
      margin-bottom: 2px !important;
      padding-bottom: 4px;
    }

    .titleCard {
      font-weight: 700;
      font-size: 16px;
      margin-bottom: 0px;
    }

    .inputLateral {
      display: flex;
      grid-gap: 5px;
      align-items: center;
      justify-content: center;
      margin-left: 10px;
    }

    .inputLateral input {
      width: 100%;
    }

    .inputLateral label {
      width: 100%;
      text-align: end;
      margin-bottom: 0px;
    }

    label {
      margin-bottom: 0px !important;
    }

    .noBackground {
      background-color: transparent !important;
      padding: 0;
      height: 35px;
      width: 35px;
    }

    #multiCollapseExample5 .card-body,
    #multiCollapseExample4 .card-body {
      padding-bottom: 1.6rem !important;
    }


    [class*=icheck-]>input:first-child:disabled+input[type=hidden]+label,
    [class*=icheck-]>input:first-child:disabled+input[type=hidden]+label::before,
    [class*=icheck-]>input:first-child:disabled+label,
    [class*=icheck-]>input:first-child:disabled+label::before {
      pointer-events: none;
      filter: alpha(opacity=1);

      -webkit-box-shadow: none;
      box-shadow: none;
      opacity: 0.90 !important
    }

    .icheck-primary {
      cursor: no-drop !important;
    }

    textarea:focus {
      border-color: #c2121a !important;
    }

    textarea {
      resize: none;
      font-size: 13.5px !important;
    }

    .quadrado {
      width: 20px;
      margin-right: 5px;
      height: 20px;
    }

    #legendas {
      flex-direction: row;
      flex-wrap: wrap;
    }
  </style>


</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <div class="content-wrapper">
      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-12">
              <div class="card" style="height:auto;min-height:715px">
                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                  <h2 class="m-0">Análise Financeira</h2>
                  <button title="Tutorial" class="mt-2 btn btn-info btn-sm ml-2" id="tutorial">
                    <i class="fas fa-question-circle"></i>
                  </button>
                </div>

                <div class="container-fluid">
                  <div class="d-flex align-items-center p-4">
                    <div id="divCliente" style="width: 100%;">
                      <label data-error="wrong" class="mb-0" data-success="right" for="txtCliente">Cliente
                      </label>
                      <div class="input-group">
                        <input type="text" data-selecionado="false" class="input-default focus form-control clientFields" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                        <div class="input-group-append">
                          <button class="btn bg-danger clientFields" id="btnCliente" name="btn-cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger clientFields" id="btn-limpa-cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                    <!-- d-flex items-start flex-wrap -->
                    <div class="d-flex items-start flex-wrap" id="divBuscaGrupo">
                      <div class="form-check ml-2">
                        <input class="form-check-input clientFields" type="checkbox" id="cbGrupoClienteResumo"> <label for="cbGrupoClienteResumo">Buscar por Grupo do Cliente</label>
                      </div>
                    </div>
                    <div class="d-flex align-items-end" style="height: 58px;">
                      <button class="btn btn-danger btn-sisp clientFields ml-2 mr-2" id="btnConsultarCliente"><i class="fas fa-search"></i>Consultar</button>
                      <button id="btnImprimirCliente" class="btn-sisp btn btn-secondary clientFields"><i class="fas fa-print"></i> Imprimir</button>
                    </div>
                  </div>
                  <div class="row card-body d-flex" id="abaGeral">

                    <nav class="col-lg-12">
                      <div class="nav nav-tabs d-flex flex-nowrap" id="nav-tab" role="tablist" style="text-decoration: none; max-width: none!important; white-space: nowrap!important; overflow-x: auto!important; overflow-y: hidden">
                        <a class="nav-link abaLink active" id="tabResumo" data-toggle="tab" href="#divResumo" role="tab" aria-controls="divResumo" aria-selected="true">Resumo</a>
                        <a class="nav-link abaLink" id="tabEstatisticas" data-toggle="tab" href="#divEstatisticas" role="tab" aria-controls="divEstatisticas" aria-selected="false">Estatisticas</a>
                        <a class="nav-link abaLink" id="tabInfoMerc" data-toggle="tab" href="#divInfoMerc" role="tab" aria-controls="divInfoMerc" aria-selected="false">Informações Mercadológicas</a>
                        <a class="nav-link abaLink" id="tabSerasa" data-toggle="tab" href="#divSerasa" role="tab" aria-controls="divSerasa" aria-selected="false">Serasa</a>
                      </div>
                    </nav>
                    <div class="tab-content col-12 row" style="min-height: 505px;" id="nav-tabContent">

                      <div class="tab-pane fade show active col-12" id="divResumo" role="tabpanel" aria-labelledby="tabResumo">
                        <div class="col-12 d-flex px-0">

                          <fieldset class="mb-2 card col-9 px-0">

                            <div class="card card-header" role="tab" id="dadosCliente">
                              <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample1" href="#multiCollapseExample1" aria-expanded="true" aria-controls="collapseOne1">
                                <div class="row">
                                  <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                    <i class="fas fa-angle-down"></i>
                                  </div>
                                  <div class="col-11">
                                    <h4 class="title-page">
                                      Dados do Cliente
                                    </h4>
                                  </div>
                                </div>
                              </a>
                            </div>

                            <div class="collapse" id="multiCollapseExample1">
                              <div class="card card-body">
                                <div class=" tab-pane fade show active" role="tabpanel" aria-labelledby="geral-tab">
                                  <div class="row mt-3">
                                    <div class="col-4">
                                      <div class="row dados">
                                        <div class="col-lg-3 col-12">
                                          <label for="txtCodigo">Código</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtCodigo" name="txtCodigo">
                                          </div>
                                        </div>
                                        <div class="col-lg-9  col-12 ">
                                          <label for="txtCNPJ">CNPJ/CPF</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtCNPJ" name="txtCNPJ">
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row dados">
                                        <div class="col-lg-12 col-12 ">
                                          <label for="txtRazaoSocial">Razão Social</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtRazaoSocial" name="txtRazaoSocial">
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row dados">
                                        <div class="col-lg-12  col-12 ">
                                          <label for="txtFantasia">Fantasia</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtFantasia" name="txtFantasia">
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row dados">
                                        <div class="col-lg-12  col-12">
                                          <label for="txtRepresentante">Representante</label>
                                          <div class="row">
                                            <div class="col-12">
                                              <input disabled type="text" class="inputInvisivel" id="txtRepresentante" name="txtRepresentante">
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row dados">
                                        <div class="col-lg-12  col-12 ">
                                          <label for="txtEmail">Email</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtEmail" name="txtEmail">
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row dados">
                                        <div class="col-lg-12  col-12 ">
                                          <label for="txtEndereco">Endereço</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtEndereco" name="txtEndereco">
                                          </div>
                                        </div>
                                      </div>

                                      <div class="row dados">
                                        <div class="col-lg-8  col-12 ">
                                          <label for="txtBairro">Bairro</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtBairro" name="txtBairro">
                                          </div>
                                        </div>
                                        <div class="col-lg-4  col-12 ">
                                          <label for="txtNumero">Número</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtNumero" name="txtNumero">
                                          </div>
                                        </div>
                                      </div>
                                    </div>

                                    <div class="col-4">
                                      <div class="row dados">
                                        <div class="col-lg-12 col-12">
                                          <label for="txtInscricao">Inscrição</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtInscricao" name="txtInscricao">
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row dados">
                                        <div class="col-lg-12 col-12">
                                          <label for="txtTelefone">DDD+Telefone</label>
                                          <div class="row">
                                            <div class="col-12">
                                              <input disabled type="text" class="inputInvisivel" id="txtTelefone" name="txtTelefone">
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row dados">
                                        <div class="col-lg-12 col-12">
                                          <label for="txtFax">DDD+Fax</label>
                                          <div class="row">
                                            <div class="col-12">
                                              <input disabled type="text" class="inputInvisivel" id="txtFax" name="txtFax">
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row dados">
                                        <div class="col-lg-12 col-12">
                                          <label for="txtGrupo">Grupo</label>
                                          <div class="row">
                                            <div class="col-12">
                                              <input disabled type="text" class="inputInvisivel" id="txtGrupo" name="txtGrupo">
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row dados">
                                        <div class="col-lg-12 col-12">
                                          <label for="txtRamoAtividade">Ramo Atividade</label>
                                          <div class="row">
                                            <div class="col-12">
                                              <input disabled type="text" class="inputInvisivel" id="txtRamoAtividade" name="txtRamoAtividade">
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row dados">
                                        <div class="col-lg-6 col-12 ">
                                          <label for="txtCidade">Cidade</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtCidade" name="txtCidade">
                                          </div>
                                        </div>
                                        <div class="col-lg-6 col-12 ">
                                          <label for="txtUf">UF</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtUf" name="txtUf">
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row dados">
                                        <div class="col-lg-6 col-12 ">
                                          <label for="txtPais">Pais</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtPais" name="txtPais">
                                          </div>
                                        </div>
                                        <div class="col-lg-6 col-12 ">
                                          <label for="txtSig">Sigla</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtSig" name="txtSig">
                                          </div>
                                        </div>
                                      </div>
                                    </div>

                                    <div class="col-4">
                                      <div class="row dados">
                                        <div class="col-lg-6 col-12 icheck-primary ">
                                          <input disabled type="checkbox" id="cbAtivo" class="">
                                          <label for="cbAtivo">Ativo</label>
                                        </div>
                                        <div class="col-lg-6 col-12 icheck-primary">
                                          <input disabled type="checkbox" id="cbBloqueado" class="">
                                          <label for="cbBloqueado">Bloqueado</label>
                                        </div>
                                      </div>
                                      <div class="row dados">
                                        <div class="col-lg-6 col-12 ">
                                          <label for="txtCadastro">Cadastro</label>
                                          <div class="">
                                            <input disabled type="date" class="inputInvisivel" id="txtCadastro" name="txtCadastro">
                                          </div>
                                        </div>
                                        <div class="col-lg-6  col-12 ">
                                          <label for="txtFundacao">Fundação</label>
                                          <div class="">
                                            <input disabled type="date" class="inputInvisivel" id="txtFundacao" name="txtFundacao">
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row dados">
                                        <div class="col-lg-6  col-12 ">
                                          <label for="txtClassificacao">Classificação</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtClassificacao" name="txtClassificacao">
                                          </div>
                                        </div>
                                        <div class="col-lg-6  col-12 ">
                                          <label for="txtSituacaoComercial">Situação Comercial</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtSituacaoComercial" name="txtSituacaoComercial">
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row dados">
                                        <div class="col-lg-6  col-12 ">
                                          <label for="txtLimiteGrupo">Limite Grupo</label>
                                          <div class="">
                                            <input disabled type="text" class="inputInvisivel" id="txtLimiteGrupo" name="txtLimiteGrupo">
                                          </div>
                                        </div>
                                        <div class="col-lg-6  col-12 ">
                                          <label for="txtDataValidadeLimite">Data Validade Limite</label>
                                          <div class="">
                                            <input disabled type="date" class="inputInvisivel" id="txtDataValidadeLimite" name="txtDataValidadeLimite">
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>

                            <div class="card card-header" role="tab" id="dadosComercial">
                              <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample2" href="#multiCollapseExample2" aria-expanded="true" aria-controls="collapseOne1">
                                <div class="row">
                                  <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                    <i class="fas fa-angle-down"></i>
                                  </div>
                                  <div class="col-11">
                                    <h4 class="title-page">
                                      Dados Comercial
                                    </h4>
                                  </div>
                                </div>
                              </a>
                            </div>
                            <div class="collapse" id="multiCollapseExample2">
                              <div class="card card-body pb-3">
                                <div class=" tab-pane fade show active" role="tabpanel" aria-labelledby="geral-tab">
                                  <div class="row mt-3">
                                    <div class="col-lg-3 col-sm-6">
                                      <p class="titleCard">Último Pedido</p>
                                      <div class="valoresCard">
                                        <div class="inputLateral">Data: <input disabled type="date" class="inputInvisivel" id="txtDataUltimoPedido" name="txtDataUltimoPedido"></div>
                                        <div class="inputLateral">Número: <input disabled type="text" value="" class="inputInvisivel" id="txtNumeroÚltimoPedido" name="txtNumeroÚltimoPedido"></div>
                                        <div class="inputLateral">Valor: <input disabled type="text" value="00.00" class="inputInvisivel" id="txtValorÚltimoPedido" name="txtValorÚltimoPedido"></div>
                                      </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6">
                                      <p class="titleCard">Última Venda</p>
                                      <div class="valoresCard">
                                        <div class="inputLateral">Data: <input disabled type="date" class="inputInvisivel" id="txtDataUltimaVenda" name="txtDataUltimaVenda"></div>
                                        <div class="inputLateral">Número: <input disabled type="text" value="" class="inputInvisivel" id="txtNumeroÚltimaVenda" name="txtNumeroÚltimaVenda"></div>
                                        <div class="inputLateral">Valor: <input disabled type="text" value="00.00" class="inputInvisivel" id="txtValorÚltimaVenda" name="txtValorÚltimaVenda"></div>
                                      </div>
                                    </div>

                                    <div class="col-lg-3 col-sm-6">
                                      <p class="titleCard">Última NFC-E</p>
                                      <div class="valoresCard">
                                        <div class="inputLateral">Data: <input disabled type="date" class="inputInvisivel" id="txtDataUltimaNFCE" name="txtDataUltimaNFCE"></div>
                                        <div class="inputLateral">Serie: <input disabled type="text" value="" class="inputInvisivel" id="txtSerieÚltimaNFCE" name="txtSerieÚltimaNFCE"></div>
                                        <div class="inputLateral">Valor: <input disabled type="text" value="00.00" class="inputInvisivel" id="txtValorÚltimaNFCE" name="txtValorÚltimaNFCE"></div>
                                      </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6">
                                      <p class="titleCard">Última NF-E</p>
                                      <div class="valoresCard">
                                        <div class="inputLateral">Data: <input disabled type="date" class="inputInvisivel" id="txtDataUltimaNFE" name="txtDataUltimaNFE"></div>
                                        <div class="inputLateral">Serie: <input disabled type="text" value="" class="inputInvisivel" id="txtSerieÚltimaNFE" name="txtSerieÚltimaNFE"></div>
                                        <div class="inputLateral">Valor: <input disabled type="text" value="00.00" class="inputInvisivel" id="txtValorÚltimaNFE" name="txtValorÚltimaNFE"></div>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row mt-3">
                                    <div class="col-lg-3 col-sm-6">
                                      <p class="titleCard">Maior Acumulo</p>
                                      <div class="valoresCard">
                                        <div class="inputLateral">Data: <input disabled type="date" class="inputInvisivel" id="txtDataMaiorAcumulo" name="txtDataMaiorAcumulo"></div>
                                        <div class="inputLateral">Valor: <input disabled type="text" value="00.00" class="inputInvisivel" id="txtValorMaiorAcumulo" name="txtValorMaiorAcumulo"></div>
                                      </div>
                                    </div>

                                    <div class="col-lg-3 col-sm-6">
                                      <p class="titleCard">Maior Fatura NF-E</p>
                                      <div class="valoresCard">
                                        <div class="inputLateral">Data: <input disabled type="date" class="inputInvisivel" id="txtDataMaiorFaturaNFE" name="txtDataMaiorFaturaNFE"></div>
                                        <div class="inputLateral">Valor: <input disabled type="text" value="00.00" class="inputInvisivel" id="txtValorMaiorFaturaNFE" name="txtValorMaiorFaturaNFE"></div>
                                      </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6">
                                      <p class="titleCard">Maior Fatura NFC-E</p>
                                      <div class="valoresCard">
                                        <div class="inputLateral">Data: <input disabled type="date" class="inputInvisivel" id="txtDataMaiorFaturaNFCE" name="txtDataMaiorFaturaNFCE"></div>
                                        <div class="inputLateral">Valor: <input disabled type="text" value="00.00" class="inputInvisivel" id="txtValorMaiorFaturaNFCE" name="txtValorMaiorFaturaNFCE"></div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>

                            <div class="card card-header" role="tab" id="dadosFinanceiro">
                              <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample3" href="#multiCollapseExample3" aria-expanded="true" aria-controls="collapseOne1">
                                <div class="row">
                                  <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                    <i class="fas fa-angle-down"></i>
                                  </div>
                                  <div class="col-11">
                                    <h4 class="title-page">
                                      Dados Financeiro
                                    </h4>
                                  </div>
                                </div>
                              </a>
                            </div>
                            <div class="collapse" id="multiCollapseExample3">
                              <div class="card card-body">
                                <div class=" tab-pane fade show active" role="tabpanel" aria-labelledby="geral-tab">
                                  <div class="row mt-2 d-flex justify-content-center">
                                    <div class="col-xl-4 col-lg-6 col-xs-12">
                                      <div class="col-lg-12 col-12">
                                        <div class="inputLateral">
                                          <label for="txtAtrasoMedio">Atraso Médio:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtAtrasoMedio" name="txtAtrasoMedio">
                                        </div>
                                      </div>
                                      <div class="col-lg-12 col-12">
                                        <div class="inputLateral">
                                          <label for="txtDiasEmAtraso">Dias em Atraso:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtDiasEmAtraso" name="txtDiasEmAtraso">
                                        </div>
                                      </div>
                                      <div class="col-lg-12 col-12">
                                        <div class="inputLateral">
                                          <label for="txtDupEmAberto">Dup. em Aberto:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtDupEmAberto" name="txtDupEmAberto">
                                        </div>
                                      </div>
                                      <div class="col-lg-12 col-12">
                                        <div class="inputLateral">
                                          <label for="txtDupEmAtraso">Dup. em Atraso:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtDupEmAtraso" name="txtDupEmAtraso">
                                        </div>
                                      </div>
                                      <div class="col-lg-12 col-12">
                                        <div class="inputLateral">
                                          <label for="txtAntecipacaoDevolucao">Ante / Devo:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtAntecipacaoDevolucao" name="txtAntecipacaoDevolucao">
                                        </div>
                                      </div>
                                      <div class="col-lg-12 col-12">
                                        <div class="inputLateral">
                                          <label for="txtTotalEmAberto">Total em Aberto:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtTotalEmAberto" name="txtTotalEmAberto">
                                        </div>
                                      </div>
                                      <div class="col-lg-12 col-12">
                                        <div class="inputLateral">
                                          <label for="txtSituacaoCobranca">Situação Cobrança:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtSituacaoCobranca" name="txtSituacaoCobranca">
                                        </div>
                                      </div>

                                      <div class="col-lg-12 col-12 ">
                                        <div class="inputLateral">
                                          <label for="txtDataSituacaoCobranca">Data Situação Cobrança:</label>
                                          <input disabled type="date" class="inputInvisivel" id="txtDataSituacaoCobranca" name="txtDataSituacaoCobranca">
                                        </div>
                                      </div>

                                      <div class="col-lg-12 col-12 ">
                                        <div class="inputLateral">
                                          <label for="txtDataProximaCobranca">Data Próxima Cobrança:</label>
                                          <input disabled type="date" class="inputInvisivel" id="txtDataProximaCobranca" name="txtDataProximaCobranca">
                                        </div>
                                      </div>
                                      <div class="col-lg-12  col-12">
                                        <label>Histórico</label>
                                        <div class="d-flex gap-2">
                                          <input disabled type="text" class="input-default text-center noBackground" id="txtHistorico-1" name="txtHistorico-1">
                                          <input disabled type="text" class="input-default text-center noBackground" id="txtHistorico-2" name="txtHistorico-2">
                                          <input disabled type="text" class="input-default text-center noBackground" id="txtHistorico-3" name="txtHistorico-3">
                                          <input disabled type="text" class="input-default text-center noBackground" id="txtHistorico-4" name="txtHistorico-4">
                                          <input disabled type="text" class="input-default text-center noBackground" id="txtHistorico-5" name="txtHistorico-5">
                                          <input disabled type="text" class="input-default text-center noBackground" id="txtHistorico-6" name="txtHistorico-6">
                                          <input disabled type="text" class="input-default text-center noBackground" id="txtHistorico-7" name="txtHistorico-7">
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-4 col-lg-6 col-xs-12">
                                      <div class="col-lg-12 col-12">

                                        <div class="inputLateral">
                                          <label for="txtDuplicataPedidoVista">Duplicata Pedido à Vista:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtDuplicataPedidoVista" name="txtDuplicataPedidoVista">
                                        </div>
                                      </div>
                                      <div class="col-lg-12 col-12 ">

                                        <div class="inputLateral">
                                          <label for="txtVistaVencida">À vista Vencida:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtVistaVencida" name="txtVistaVencida">
                                        </div>
                                      </div>
                                      <div class="col-lg-12  col-12 ">

                                        <div class="inputLateral">
                                          <label for="txtJuros">Juros:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtJuros" name="txtJuros">
                                        </div>
                                      </div>
                                      <div class="col-lg-12  col-12 ">

                                        <div class="inputLateral">
                                          <label for="txtPedidosEmAberto">Pedidos em Aberto:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtPedidosEmAberto" name="txtPedidosEmAberto">
                                        </div>
                                      </div>
                                      <div class="col-lg-12  col-12 ">

                                        <div class="inputLateral">
                                          <label for="txtSituacaoCredito">Situação Crédito:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtSituacaoCredito" name="txtSituacaoCredito">
                                        </div>
                                      </div>
                                      <div class="col-lg-12 col-12">
                                        <div class="inputLateral">
                                          <label for="txtLimiteDeCredito">Limite de Crédito:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtLimiteDeCredito" name="txtLimiteDeCredito">
                                        </div>
                                      </div>
                                      <div class="col-lg-12  col-12 ">
                                        <div class="inputLateral">
                                          <label for="txtTitulosReceber">Títulos a Receber:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtTitulosReceber" name="txtTitulosReceber">
                                        </div>
                                      </div>

                                      <div class="col-lg-12 col-12 ">
                                        <div class="inputLateral">
                                          <label for="txtTotalPedidosTitulos">Total Pedidos e Títulos:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtTotalPedidosTitulos" name="txtTotalPedidosTitulos">
                                        </div>
                                      </div>
                                      <div class="col-lg-12 col-12 ">
                                        <div class="inputLateral">

                                          <label for="txtSaldoLimiteCredito">Saldo Limite de Crédito:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtSaldoLimiteCredito" name="txtSaldoLimiteCredito">
                                        </div>
                                      </div>

                                      <div class="col-lg-12 col-12 ">
                                        <div class="inputLateral">
                                          <label for="txtSaldoLimiteGrupo">Saldo Limite Grupo:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtSaldoLimiteGrupo" name="txtSaldoLimiteGrupo">
                                        </div>
                                      </div>
                                    </div>

                                    <div class="col-xl-4 col-lg-12 col-xs-12">
                                      <div class="col-lg-12 col-12">
                                        <div class="inputLateral">
                                          <label for="txtUltimoParecer">Último Parecer:</label>
                                          <input disabled type="date" class="inputInvisivel" id="txtUltimoParecer" name="txtUltimoParecer">
                                        </div>
                                      </div>
                                      <div class="col-lg-12 col-12 ">
                                        <div class="inputLateral">
                                          <label for="txtSituacaoParecer">Situação Parecer:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtSituacaoParecer" name="txtSituacaoParecer">
                                        </div>
                                      </div>
                                      <div class="col-lg-12  col-12 ">
                                        <div class="inputLateral">
                                          <label for="txtUltimaCompra">Última Compra:</label>
                                          <input disabled type="date" class="inputInvisivel" id="txtUltimaCompra" name="txtUltimaCompra">
                                        </div>
                                      </div>
                                      <div class="col-lg-12  col-12 ">
                                        <div class="inputLateral">
                                          <label for="txtUltimaFatura">Última Fatura:</label>
                                          <input disabled type="date" class="inputInvisivel" id="txtUltimaFatura" name="txtUltimaFatura">
                                        </div>
                                      </div>
                                      <div class="col-lg-12  col-12 ">
                                        <div class="inputLateral">
                                          <label for="txtSintegra">Sintegra:</label>
                                          <input disabled type="text" class="inputInvisivel" id="txtSintegra" name="txtSintegra">
                                        </div>
                                      </div>
                                      <div class="col-lg-12  col-12 ">
                                        <div class="inputLateral">
                                          <label for="txtUltimaConsSerasa">Última Cons. Serasa:</label>
                                          <input disabled type="date" class="inputInvisivel" id="txtUltimaConsSerasa" name="txtUltimaConsSerasa">
                                        </div>
                                      </div>
                                      <div class="col-lg-12  col-12 ">
                                        <div class="inputLateral">
                                          <label for="txtUltimaAtualizacaoLimite">Última Atualização Limite:</label>
                                          <input disabled type="date" class="inputInvisivel" id="txtUltimaAtualizacaoLimite" name="txtUltimaAtualizacaoLimite">
                                        </div>
                                      </div>
                                      <div class="col-lg-12  col-12 ">
                                        <div class="inputLateral">
                                          <label for="txtValidadeLimiteCredito">Validade Limite Crédito:</label>
                                          <input disabled type="date" class="inputInvisivel" id="txtValidadeLimiteCredito" name="txtValidadeLimiteCredito">
                                        </div>
                                      </div>

                                      <div class="col-lg-12 col-12 ">
                                        <div class="inputLateral">
                                          <label for="txtPeriodoBaseDe">Período Base de:</label>
                                          <input disabled type="date" class="inputInvisivel" id="txtPeriodoBaseDe" name="txtPeriodoBaseDe">
                                          <label for="txtPeriodoBaseAte" style="width: 30px;">Até:</label>
                                          <input disabled type="date" class="inputInvisivel" id="txtPeriodoBaseAte" name="txtPeriodoBaseAte">
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>

                            <div class="card card-header" role="tab">
                              <a style="width:100%;" id="abaHistoricoOcorrencias" data-toggle="collapse" data-parent="#multiCollapseExample6" href="#multiCollapseExample6" aria-expanded="true" aria-controls="collapseOne1">
                                <div class="row">
                                  <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                    <i class="fas fa-angle-right"></i>
                                  </div>
                                  <div class="col-11">
                                    <h4 class="title-page">
                                      Histórico / Ocorrências
                                    </h4>
                                  </div>
                                </div>
                              </a>
                            </div>
                            <div class="collapse" id="multiCollapseExample6">
                              <div class="card card-body">
                                <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="venda-tab">
                                  <div class="pt-2 form-row">
                                    <div class="col-lg-12 table-selecttable-lg">
                                      <table id="tabelaHistoricoOcorrencias" class="table table-sm table-select table-hover" style="width: 100%; white-space: nowrap">
                                        <thead>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                      </table>
                                    </div>
                                    <button type="button" class="btn btn-primary btn-sisp mt-2" id="btnAlteraOcorrencias">Incluir/Excluir Ocorrências</button>
                                  </div>
                                </div>
                              </div>
                            </div>

                            <div class="row">
                              <div class="col-6">

                                <div class="card card-header" role="tab" id="obsCliente">
                                  <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample4" href="#multiCollapseExample4" aria-expanded="true" aria-controls="collapseOne1">
                                    <div class="row">
                                      <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                        <i class="fas fa-angle-down"></i>
                                      </div>
                                      <div class="col-11">
                                        <h4 class="title-page">
                                          Observações Cliente
                                        </h4>
                                      </div>
                                    </div>
                                  </a>
                                </div>

                                <div class="collapse" id="multiCollapseExample4">
                                  <div class="card card-body p-0 pt-2" style="height: 100%;">
                                    <div class=" tab-pane fade show active" role="tabpanel" aria-labelledby="geral-tab">
                                      <div class="row" style="height: 100%; overflow-x: true">
                                        <div class="col-sm-12 table-responsive">
                                          <table id="tabelaObsCliente" style="max-height: 250px;" width="100%" class="table table-select table-hover">
                                          </table>
                                        </div>

                                        <div class="col-12 d-flex align-items-center justify-content-end mt-2">
                                          <button class="btn btn-sisp btn-danger ml-2" id="btnGravarObs">Gravar Nova Observação</button>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>

                              <div class="col-6 pl-0">

                                <div class="card card-header" role="tab" id="empresaColigadasGrupoCliente">
                                  <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample5" href="#multiCollapseExample5" aria-expanded="true" aria-controls="collapseOne1">
                                    <div class="row">
                                      <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                        <i class="fas fa-angle-down"></i>
                                      </div>
                                      <div class="col-11">
                                        <h4 class="title-page">
                                          Empresas Coligadas por Grupo de Cliente
                                        </h4>
                                      </div>
                                    </div>
                                  </a>
                                </div>
                                <div class="collapse" id="multiCollapseExample5">
                                  <div class="card card-body" style="height: 100%;">
                                    <div class=" tab-pane fade show active" role="tabpanel" aria-labelledby="geral-tab">
                                      <div class="row" style="height: 100%;">
                                        <div class="col-sm-12 pt-2 table-responsive" style="max-height: 250px; overflow-x:  auto">
                                          <table id="tabelaEmpresasColigadasGrupoCliente" class="table table-sm table-select table-hover" width="100%">
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                          </table>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </fieldset>
                          <fieldset class="mb-2 card col-3 pr-0">
                            <div class="card card-header" role="tab">
                              <a style="width:100%;" id="abaReferencias" data-toggle="collapse" data-parent="#multiCollapseExample7" href="#multiCollapseExample7" aria-expanded="true" aria-controls="collapseOne1">
                                <div class="row">
                                  <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                    <i class="fas fa-angle-right"></i>
                                  </div>
                                  <div class="col-11">
                                    <h4 class="title-page">
                                      Referências
                                    </h4>
                                  </div>
                                </div>
                              </a>
                            </div>

                            <div class="collapse" id="multiCollapseExample7">
                              <div class="card card-body">
                                <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="venda-tab">
                                  <div class="py-2 form-row">
                                    <div class="col-lg-12 table-selecttable-lg">
                                      <table id="tabelaReferencias" class="table table-sm table-select table-hover" style="width: 100%; white-space: nowrap">
                                        <thead>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                      </table>
                                    </div>
                                    <button type="button" class="btn btn-primary btn-sisp mt-2" id="btnAlteraReferencias">Manutenção Referências</button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </fieldset>
                        </div>
                      </div>

                      <div class="tab-pane fade col-12" id="divEstatisticas" role="tabpanel" aria-labelledby="tabEstatisticas">

                        <fieldset class="mb-2 card">
                          <div class="row card-body d-flex" id="abaEstatisticas">

                            <nav class="col-lg-12">
                              <div class="nav nav-tabs d-flex flex-nowrap" id="nav-tab" role="tablist" style="text-decoration: none; max-width: none!important; white-space: nowrap!important; overflow-x: auto!important; overflow-y: hidden">
                                <a class="nav-link abaLink active" id="tabDuplicatas" data-toggle="tab" href="#divDuplicatas" role="tab" aria-controls="divDuplicatas" aria-selected="true">Duplicatas</a>
                                <a class="nav-link abaLink" id="tabPedidos" data-toggle="tab" href="#divPedidos" role="tab" aria-controls="divPedidos" aria-selected="false">Pedidos</a>
                                <a class="nav-link abaLink " id="tabVendas" data-toggle="tab" href="#divVendas" role="tab" aria-controls="divVendas" aria-selected="false">Vendas</a>
                                <a class="nav-link abaLink" id="tabFaturas" data-toggle="tab" href="#divFaturas" role="tab" aria-controls="divFaturas" aria-selected="false">Faturas</a>
                              </div>
                            </nav>
                            <div class="tab-content col-lg-12" style="min-height: 450px;" id="nav-tabContent">

                              <div class="tab-pane fade show active" id="divDuplicatas" role="tabpanel" aria-labelledby="tabDuplicatas">

                                <fieldset class="mb-2 p-3">
                                  <div class="row">
                                    <div class="col-lg-4 col-6">
                                      <div class="row">
                                        <div class="col-lg-12 col-12">
                                          <div class="d-flex row">
                                            <div class="col-6">
                                              <label for="txtDataVencimentoDuplicatasDe">Vencimento de:</label>

                                              <input type="date" class="input-default focus form-control" id="txtDataVencimentoDuplicatasDe" name="txtDataVencimentoDuplicatasDe" value="1200-01-01">
                                            </div>
                                            <div class="col-6" style="margin-left: -14px;">
                                              <label for="txtDataVencimentoDuplicatasAte" style="width: 30px;">Até:</label>
                                              <input type="date" class="input-default focus form-control" id="txtDataVencimentoDuplicatasAte" name="txtDataVencimentoDuplicatasAte" value="2500-01-01">
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row">
                                        <div class="col-lg-12 col-12">
                                          <div class="d-flex row">
                                            <div class="col-6">
                                              <label for="txtRecebimentoDuplicatasDe">Recebimento de:</label>

                                              <input type="date" class="input-default focus form-control" id="txtRecebimentoDuplicatasDe" name="txtRecebimentoDuplicatasDe" value="1200-01-01">
                                            </div>
                                            <div class="col-6" style="margin-left: -14px;">
                                              <label for="txtRecebimentoDuplicatasAte" style="width: 30px;">Até:</label>
                                              <input type="date" class="input-default focus form-control" id="txtRecebimentoDuplicatasAte" name="txtRecebimentoDuplicatasAte" value="2500-01-01">
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row">
                                        <div class="col-lg-12 col-12">
                                          <div class="d-flex row">
                                            <div class="col-6">
                                              <label for="txtEmissaoDuplicatasDe">Emissão de:</label>

                                              <input type="date" class="input-default focus form-control" id="txtEmissaoDuplicatasDe" name="txtEmissaoDuplicatasDe" value="1200-01-01">
                                            </div>
                                            <div class="col-6" style="margin-left: -14px;">
                                              <label for="txtEmissaoDuplicatasAte" style="width: 30px;">Até:</label>
                                              <input type="date" class="input-default focus form-control" id="txtEmissaoDuplicatasAte" name="txtEmissaoDuplicatasAte" value="2500-01-01">
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-lg-4 col-6">
                                      <div class="row">
                                        <div class="col-lg-6 col-6">
                                          <fieldset class="form border-Field mb-2 pb-0">
                                            <legend class="textoBorda mb-0 pb-0">Situação</legend>
                                            <div class="d-flex flex-column">
                                              <div class="icheck-primary mr-3"><input type="radio" value="0" id="radioTodosDuplicatas" checked="checked" name="radioSituacaoDup"><label for="radioTodosDuplicatas">Todos</label></div>
                                              <div class="icheck-primary"><input type="radio" value="1" id="radioEmAbertoDuplicatas" name="radioSituacaoDup"> <label for="radioEmAbertoDuplicatas">Em Aberto</label></div>
                                              <div class="icheck-primary"><input type="radio" value="2" id="radioPagasDuplicatas" name="radioSituacaoDup"> <label for="radioPagasDuplicatas">Pagas</label></div>
                                            </div>
                                          </fieldset>
                                        </div>
                                        <div class="col-lg-6 col-6">
                                          <fieldset class="form border-Field mb-2 pb-0">
                                            <legend class="textoBorda mb-0 pb-0">Listar</legend>
                                            <div class="d-flex flex-column">
                                              <div class="icheck-primary mr-3"><input type="radio" value="0" id="radioTodosListarDuplicatas" checked="checked" name="radioListarDup"><label for="radioTodosListarDuplicatas">Todos</label></div>
                                              <div class="icheck-primary"><input type="radio" value="1" id="radioListarDuplicatas" name="radioListarDup"> <label for="radioListarDuplicatas">Duplicatas</label></div>
                                              <div class="icheck-primary"><input type="radio" value="2" id="radioAntecipacaoDuplicatas" name="radioListarDup"> <label for="radioAntecipacaoDuplicatas">Antecipação</label></div>
                                            </div>
                                          </fieldset>
                                        </div>
                                      </div>
                                      <div class="col-12 mt-3">
                                        <div class="d-flex items-start flex-wrap">
                                          <div class="form-check ml-2">
                                            <input class="form-check-input" type="checkbox" id="cbGrupoClienteDuplicatas"> <label for="cbGrupoClienteDuplicatas">Buscar por Grupo do Cliente</label>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-lg-4 col-6">
                                      <div class="col-lg-6">
                                        <label for="txtOrdemDuplicatas">Opção de Relatório:</label>
                                        <div class="relative d-flex align-items-center">
                                          <select id="txtOrdemDuplicatas" class="input-default focus custom-select">
                                          </select>
                                          <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                                            <i class="fas fa-check"></i>
                                          </button>
                                        </div>
                                      </div>
                                      <button class="btn btn-sisp btn-primary ml-2 mr-2 mt-3" id="btnConsultarDuplicatas">Consultar</button>
                                      <button id="btnImprimirDuplicatas" class="btn-sisp btn btn-secondary mt-3"><i class="fas fa-print"></i> Imprimir</button>
                                    </div>
                                  </div>

                                  <div class="row" style="height: 100%;">
                                    <div class="col-sm-7 pt-2 table-responsive">
                                      <table id="tabelaEstatisticasDuplicatas" class="table table-sm table-select table-hover" width="100%">
                                        <thead>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                      </table>
                                    </div>
                                    <div class="col-sm-5 pt-2 d-flex justify-content-center align-items-center" style="height: 100%;">
                                      <div id="graficoAFDuplicatas"></div>
                                    </div>
                                  </div>
                                </fieldset>
                              </div>
                              <div class="tab-pane fade" id="divPedidos" role="tabpanel" aria-labelledby="tabPedidos">

                                <fieldset class="mb-2 p-3">
                                  <div class="row">
                                    <div class="col-lg-4 col-6">
                                      <div class="row">
                                        <div class="col-lg-12 col-12">
                                          <div class="d-flex row">
                                            <div class="col-6">
                                              <label for="txtDtEmissaoPedidoDe">Emissão de:</label>
                                              <input type="date" class="input-default focus form-control" id="txtDtEmissaoPedidoDe" name="txtDtEmissaoPedidoDe" value="1200-01-01">
                                            </div>
                                            <div class="col-6" style="margin-left: -14px;">
                                              <label for="txtDtEmissaoPedidoAte" style="width: 30px;">Até:</label>
                                              <input type="date" class="input-default focus form-control" id="txtDtEmissaoPedidoAte" name="txtDtEmissaoPedidoAte" value="2500-01-01">
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row">
                                        <div class="col-lg-12 col-12">
                                          <div class="d-flex row">
                                            <div class="col-6">
                                              <label for="txtDtPrevFaturamentoPedidoDe">Recebimento de:</label>

                                              <input type="date" class="input-default focus form-control" id="txtDtPrevFaturamentoPedidoDe" name="txtDtPrevFaturamentoPedidoDe" value="1200-01-01">
                                            </div>
                                            <div class="col-6" style="margin-left: -14px;">
                                              <label for="txtDtPrevFaturamentoPedidoAte" style="width: 30px;">Até:</label>
                                              <input type="date" class="input-default focus form-control" id="txtDtPrevFaturamentoPedidoAte" name="txtDtPrevFaturamentoPedidoAte" value="2500-01-01">
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                    </div>

                                    <div class="col-lg-2 col-6">
                                      <fieldset class="form border-Field mb-2 pb-0">
                                        <legend class="textoBorda mb-0 pb-0">Situação</legend>
                                        <div class="d-flex flex-column">
                                          <div class="icheck-primary mr-3"><input type="radio" value="0" id="radioTodosPedido" name="radioSituacaoPedido" checked="checked"><label for="radioTodosPedido">Todos</label></div>
                                          <div class="icheck-primary"><input type="radio" value="1" id="radioPendentesPedido" name="radioSituacaoPedido"> <label for="radioPendentesPedido">Pendentes</label></div>
                                          <div class="icheck-primary"><input type="radio" value="2" id="radioFaturadosPedido" name="radioSituacaoPedido"> <label for="radioFaturadosPedido">Faturados</label></div>
                                        </div>
                                      </fieldset>
                                    </div>
                                    <div class="col-lg-2 col-6 pt-2">
                                      <div class="d-flex items-start flex-wrap">
                                        <div class="form-check ml-2">
                                          <input class="form-check-input" type="checkbox" id="cbGrupoClientePedido"> <label for="cbGrupoClientePedido">Buscar por Grupo do Cliente</label>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-lg-4 col-6">
                                      <div class="col-lg-6">
                                        <label for="txtOrdemPedidos">Opção de Relatório:</label>
                                        <div class="relative d-flex align-items-center">
                                          <select id="txtOrdemPedidos" class="input-default focus custom-select">
                                          </select>
                                          <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                                            <i class="fas fa-check"></i>
                                          </button>
                                        </div>
                                      </div>
                                      <button class="btn btn-sisp btn-primary ml-2 mr-2 mt-3" id="btnConsultarPedidos">Consultar</button>
                                      <button id="btnImprimirPedidos" class="btn-sisp btn btn-secondary mt-3"><i class="fas fa-print"></i> Imprimir</button>
                                    </div>
                                  </div>


                                  <div class="row" style="height: 100%;">
                                    <div class="col-sm-7 pt-2 table-responsive">
                                      <table id="tabelaEstatisticasPedidos" class="table table-sm table-select table-hover" width="100%">
                                        <thead>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                      </table>
                                    </div>
                                    <div class="col-sm-5 pt-2 d-flex justify-content-center align-items-center" style="height: 100%;">
                                      <div id="graficoAFPedidos"></div>
                                    </div>
                                  </div>
                                </fieldset>
                              </div>

                              <div class="tab-pane fade" id="divVendas" role="tabpanel" aria-labelledby="tabVendas">
                                <fieldset class="mb-2 p-3">
                                  <div class="row">
                                    <div class="col-lg-4 col-4">
                                      <div class="row">
                                        <div class="col-lg-12 col-12">
                                          <div class="d-flex row">
                                            <div class="col-6">
                                              <label for="txtDtEmissaoVendaDe">Emissão de:</label>
                                              <input type="date" class="input-default focus form-control" id="txtDtEmissaoVendaDe" name="txtDtEmissaoVendaDe" value="1200-01-01">
                                            </div>
                                            <div class="col-6" style="margin-left: -14px;">
                                              <label for="txtDtEmissaoVendaAte" style="width: 30px;">Até:</label>
                                              <input type="date" class="input-default focus form-control" id="txtDtEmissaoVendaAte" name="txtDtEmissaoVendaAte" value="2500-01-01">
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                    </div>

                                    <div class="col-lg-4 col-4 pt-3 d-flex flex-column">
                                      <div class="d-flex items-start flex-wrap">
                                        <div class="form-check ml-2">
                                          <input class="form-check-input" type="checkbox" id="cbEmitido" checked> <label for="cbEmitido">Emitido</label>
                                        </div>
                                        <div class="form-check ml-2">
                                          <input class="form-check-input" type="checkbox" id="cbDevolvido" checked> <label for="cbDevolvido">Devolvido</label>
                                        </div>
                                        <div class="form-check ml-2">
                                          <input class="form-check-input" type="checkbox" id="cbPendente" checked> <label for="cbPendente">Pendente</label>
                                        </div>
                                        <div class="form-check ml-2">
                                          <input class="form-check-input" type="checkbox" id="checkCanceladas" checked> <label for="checkCanceladas">Canceladas</label>
                                        </div>
                                        <div class="form-check ml-2">
                                          <input class="form-check-input" type="checkbox" id="cbAgrupada" checked> <label for="cbAgrupada">Agrupada</label>
                                        </div>
                                      </div>
                                      <div class="d-flex items-start flex-wrap mt-2">
                                        <div class="form-check ml-2">
                                          <input class="form-check-input" type="checkbox" id="cbGrupoClienteVenda"> <label for="cbGrupoClienteVenda">Buscar por Grupo do Cliente</label>
                                        </div>
                                      </div>
                                    </div>

                                    <div class="col-lg-4 col-6">
                                      <div class="col-lg-6">
                                        <label for="txtOrdemVendas">Opção de Relatório:</label>
                                        <div class="relative d-flex align-items-center">
                                          <select id="txtOrdemVendas" class="input-default focus custom-select">
                                          </select>
                                          <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                                            <i class="fas fa-check"></i>
                                          </button>
                                        </div>
                                      </div>
                                      <button class="btn btn-sisp btn-primary ml-2 mr-2 mt-3" id="btnConsultarVendas">Consultar</button>
                                      <button id="btnImprimirVendas" class="btn-sisp btn btn-secondary mt-3"><i class="fas fa-print"></i> Imprimir</button>
                                    </div>
                                  </div>

                                  <div class="row" style="height: 100%;">
                                    <div class="col-sm-7 pt-2 table-responsive">
                                      <table id="tabelaEstatisticasVendas" class="table table-sm table-select table-hover" width="100%">
                                        <thead>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                      </table>
                                    </div>
                                    <div class="col-sm-5 pt-2 d-flex justify-content-center align-items-center" style="height: 100%;">
                                      <div id="graficoAFVendas"></div>
                                    </div>
                                  </div>
                                </fieldset>
                              </div>
                              <div class="tab-pane fade" id="divFaturas" role="tabpanel" aria-labelledby="tabFaturas">

                                <fieldset class="mb-2 p-3">
                                  <div class="row">
                                    <div class="col-lg-4 col-6">
                                      <div class="d-flex row">
                                        <div class="col-6">
                                          <label for="txtDtEmissaoFaturaDe">Emissão de:</label>
                                          <input type="date" class="input-default focus form-control" id="txtDtEmissaoFaturaDe" name="txtDtEmissaoFaturaDe" value="1200-01-01">
                                        </div>
                                        <div class="col-6" style="margin-left: -14px;">
                                          <label for="txtDtEmissaoFaturaAte" style="width: 30px;">Até:</label>
                                          <input type="date" class="input-default focus form-control" id="txtDtEmissaoFaturaAte" name="txtDtEmissaoFaturaAte" value="2500-01-01">
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-lg-4 col-6 pt-3">
                                      <div class="d-flex items-start flex-wrap">
                                        <div class="form-check ml-2">
                                          <input class="form-check-input" type="checkbox" id="cbGrupoClienteFatura"> <label for="cbGrupoClienteFatura">Buscar por Grupo do Cliente</label>
                                        </div>
                                      </div>
                                    </div>

                                    <div class="col-lg-4 col-6" style="width: 100%;">
                                      <div class="col-lg-6">
                                        <label for="txtOrdemFaturas">Opção de Relatório:</label>
                                        <div class="relative d-flex align-items-center">
                                          <select id="txtOrdemFaturas" class="input-default focus custom-select">
                                          </select>
                                          <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                                            <i class="fas fa-check"></i>
                                          </button>
                                        </div>
                                      </div>
                                      <button class="btn btn-sisp btn-primary ml-2 mr-2 mt-3" id="btnConsultarFaturas">Consultar</button>
                                      <button id="btnImprimirFaturas" class="btn-sisp btn btn-secondary mt-3"><i class="fas fa-print"></i> Imprimir</button>
                                    </div>

                                    <div class="row" style="width:100%;height: 100%;">
                                      <div class="col-sm-7 pt-2 table-responsive" style>
                                        <table id="tabelaEstatisticasFaturas" class="table table-sm table-select table-hover" width="100%">
                                          <thead>
                                          </thead>
                                          <tbody>
                                          </tbody>
                                        </table>
                                      </div>
                                      <div class="col-sm-5 pt-2 d-flex justify-content-center align-items-center" style="height: 100%;">
                                        <div id="graficoAFFaturas"></div>
                                      </div>
                                    </div>
                                  </div>
                                </fieldset>
                              </div>
                            </div>
                          </div>
                        </fieldset>
                      </div>

                      <div class="tab-pane fade col-12" id="divInfoMerc" role="tabpanel" aria-labelledby="tabInfoMerc">

                        <fieldset class="mb-2 card px-3 pt-1 pb-3">
                          <div class="form-card">
                            <div class="row col-12 pr-0">

                              <div class="col-lg-2 col-sm-12 col-xs-12 mt-2">
                                <div class="d-flex">
                                  <fieldset class="form border-Field mb-0 pb-0">
                                    <legend class="textoBorda mb-0 pb-0">Opções</legend>
                                    <div class="form-row">
                                      <div class="icheck-primary pr-3">
                                        <input type="checkbox" id="cbPredioProprio" class="inputsInfoMerc" disabled>
                                        <label class="" for="cbPredioProprio">Prédio Próprio</label>
                                      </div>
                                      <div class="icheck-primary pr-3">
                                        <input type="checkbox" id="cbLibCanal" class="inputsInfoMerc" disabled>
                                        <label class="" for="cbLibCanal">Lib. Canal</label>
                                      </div>
                                    </div>
                                  </fieldset>
                                </div>
                              </div>

                              <div class="col-lg-4 col-sm-12 col-xs-12">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtInstagram">Instagram: </label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control inputsInfoMerc" disabled id="txtInstagram" name="txtInstagram" class="form-control" placeholder="Instagram">
                                </div>
                              </div>

                              <div class="col-lg-4 col-sm-12 col-xs-12">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtReferenciaCom">Referência Comercial: </label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control inputsInfoMerc" disabled id="txtReferenciaCom" name="txtReferenciaCom" class="form-control" placeholder="Referência Comercial">
                                </div>
                              </div>

                              <div class="col-lg-2 col-sm-12 col-xs-12 pr-0">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtQtdeFunc">Qtde Funcionários: </label>
                                <div class="input-group">
                                  <input type="number" class="input-default focus form-control inputsInfoMerc" disabled id="txtQtdeFunc" name="txtQtdeFunc" class="form-control" placeholder="Qtde Funcionários" oninput="this.value = this.value.replace(/[^0-9]/g, '')">
                                </div>
                              </div>

                            </div>

                            <div class="row col-12 mb-2 pr-0">
                              <div class="form-group col-12 pr-0">
                                <label data-error="wrong" data-success="right" for="txtParecer">Parecer Loja:</label>
                                <div class="input-group">
                                  <textarea id="txtParecer" maxlength="1024" placeholder="Parecer Loja" class="form-control inputsInfoMerc" disabled rows="3"></textarea>
                                </div>
                              </div>
                            </div>

                            <div class="col-12 d-flex justify-content-end">
                              <button type="button" class="btn btn-primary btn-sisp mt-2" id="btnAlterarInfoMerc">Alterar</button>
                              <div class="d-none" id="divBtnAcoesInfoMerc">
                                <button type="button" class="btn btn-secondary btn-sisp mt-2" id="btnDesistirInfoMerc">Desistir</button>
                                <button type="button" class="btn btn-primary btnVerde btn-sisp mt-2" id="btnConfirmarInfoMerc">Confirmar</button>
                              </div>
                            </div>
                          </div>
                        </fieldset>
                      </div>

                      <div class="tab-pane fade col-12" id="divSerasa" role="tabpanel" aria-labelledby="tabSerasa">

                        <fieldset class="mb-2 card px-3 pt-1 pb-3">
                          <div class="form-card">

                            <div class="d-flex align-items-end flex-wrap mb-2">
                              <div class="col-lg-5 col-sm-12 d-flex justify-content-start mb-2 mb-lg-0" style="transform: translateY(12px);">
                                <fieldset class="border-Field w-100 mb-0">
                                  <legend class="textoBorda mb-0" style="font-size: 0.9rem;">Legenda Serasa Score (Risco de Crédito)</legend>
                                  <div class="d-flex flex-wrap align-items-center" id="legendas">
                                    <div style="margin: 2px 10px 5px 0px" class="d-flex align-items-center">
                                      <div class="quadrado" style="background: #ff7f00;"></div>
                                      <span>Risco iminente</span>
                                    </div>
                                    <div style="margin: 2px 10px 5px 0px" class="d-flex align-items-center">
                                      <div class="quadrado" style="background: #ffeb3b;"></div>
                                      <span>Risco médio a relevante</span>
                                    </div>
                                    <div style="margin: 2px 10px 5px 0px" class="d-flex align-items-center">
                                      <div class="quadrado" style="background: #00c551;"></div>
                                      <span>Risco baixo a médio</span>
                                    </div>
                                    <div style="margin: 2px 0px 5px 0px" class="d-flex align-items-center">
                                      <div class="quadrado" style="background: #007bff;"></div>
                                      <span>Risco mínimo a baixo</span>
                                    </div>
                                  </div>
                                </fieldset>
                              </div>

                              <div class="col-lg-7 col-sm-12 d-flex align-items-end justify-content-end flex-wrap">
                                <div class="col-lg-6 col-sm-12 mb-2 mb-lg-0">
                                  <label class="labelGeral" for="txtUsuarioSerasa">Usuário da Última Consulta:</label>
                                  <input type="text" class="input-default focus form-control" disabled id="txtUsuarioSerasa" placeholder="Usuário">
                                </div>

                                <div class="col-lg-3 col-sm-12 mb-2 mb-lg-0">
                                  <label for="txtDtUltimaConsultaSerasa">Data da Última Consulta:</label>
                                  <input type="date" class="input-default focus form-control" readonly id="txtDtUltimaConsultaSerasa" value="1200-01-01">
                                </div>

                                <div class="col-auto d-flex justify-content-end pr-0">
                                  <button class="btn btnVerde btn-sisp clientFields" id="btnSerasa">
                                    <i class="fas fa-redo mr-1"></i>Buscar Relato (Serasa)
                                  </button>
                                </div>
                              </div>
                            </div>

                            <h4>Dados da Empresa</h4>

                            <div class="row col-12 pr-0">

                              <div class="col-lg-3 col-sm-12 col-xs-12 d-flex align-items-end justify-content-start">
                                <div class="col-sm-12 pt-2 d-flex justify-content-start align-items-start" style="height: 300px;">
                                  <div id="graficoScore" style="width: 400px; height: 300px;"></div>
                                </div>
                              </div>

                              <div class="row col-lg-9 col-sm-12 col-xs-12 d-flex align-itens-end">

                                <div class="form-group col-lg-6 col-sm-12 col-xs-12">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtRazaoSocialSerasa">Razão Social: </label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtRazaoSocialSerasa" name="txtRazaoSocialSerasa" class="form-control" placeholder="Razão Social">
                                  </div>
                                </div>

                                <div class="form-group col-lg-6 col-sm-12 col-xs-12">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtFantasiaSerasa">Fantasia: </label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtFantasiaSerasa" name="txtFantasiaSerasa" class="form-control" placeholder="Fantasia">
                                  </div>
                                </div>

                                <div class="form-group col-lg-2 col-sm-12 col-xs-12">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCNPJSerasa">CNPJ: </label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtCNPJSerasa" name="txtCNPJSerasa" class="form-control" placeholder="CNPJ">
                                  </div>
                                </div>

                                <div class="form-group col-lg-4 col-sm-12 col-xs-12">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtSituacaoCNPJSerasa">Situação CNPJ: </label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtSituacaoCNPJSerasa" name="txtSituacaoCNPJSerasa" class="form-control" placeholder="Situação CNPJ">
                                  </div>
                                </div>

                                <div class="form-group col-lg-6 col-sm-12 col-xs-12">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtEnderecoSerasa">Endereço: </label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtEnderecoSerasa" name="txtEnderecoSerasa" class="form-control" placeholder="Endereço">
                                  </div>
                                </div>

                                <div class="form-group col-lg-4 col-sm-12 col-xs-12">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtSiteSerasa">Site: </label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtSiteSerasa" name="txtSiteSerasa" class="form-control" placeholder="Site">
                                  </div>
                                </div>

                                <div class="form-group col-lg-4 col-sm-12 col-xs-12">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtOpcaoTributariaSerasa">Opção Tributária: </label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtOpcaoTributariaSerasa" name="txtOpcaoTributariaSerasa" class="form-control" placeholder="Opção Tributária">
                                  </div>
                                </div>

                                <div class="form-group col-lg-1 col-sm-12 col-xs-12">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtDDDSerasa">DDD: </label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtDDDSerasa" name="txtDDDSerasa" class="form-control" placeholder="DDD">
                                  </div>
                                </div>

                                <div class="form-group col-lg-3 col-sm-12 col-xs-12">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtTelefoneSerasa">Telefone: </label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtTelefoneSerasa" name="txtTelefoneSerasa" class="form-control" placeholder="Telefone">
                                  </div>
                                </div>

                                <div class="form-group col-lg-4 col-sm-12 col-xs-12">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtRamoAtividadeSerasa">Ramo de Atividade: </label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtRamoAtividadeSerasa" name="txtRamoAtividadeSerasa" class="form-control" placeholder="Ramo de Atividade">
                                  </div>
                                </div>

                                <div class="form-group col-lg-4 col-sm-12 col-xs-12">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtInscricaoSerasa">Inscrição Estadual: </label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtInscricaoSerasa" name="txtInscricaoSerasa" class="form-control" placeholder="Inscrição Estadual">
                                  </div>
                                </div>

                                <div class="form-group col-lg-2 col-sm-12 col-xs-12">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtRegistroSerasa">Registro: </label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtRegistroSerasa" name="txtRegistroSerasa" class="form-control" placeholder="Registro">
                                  </div>
                                </div>

                                <div class="form-group col-lg-2 col-sm-12 col-xs-12">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtRegistradoEmSerasa">Registrado Em: </label>
                                  <div class="input-group">
                                    <input type="date" class="input-default focus form-control" readonly id="txtRegistradoEmSerasa" name="txtRegistradoEmSerasa" value="1200-01-01">
                                  </div>
                                </div>

                              </div>

                              <div class="form-group col-lg-2 col-sm-12 col-xs-12">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtFundacaoSerasa">Fundação: </label>
                                <div class="input-group">
                                  <input type="date" class="input-default focus form-control" readonly id="txtFundacaoSerasa" name="txtFundacaoSerasa" value="1200-01-01">
                                </div>
                              </div>

                              <div class="form-group col-lg-2 col-sm-12 col-xs-12">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtNumFuncionariosSerasa">Número de Funcionários: </label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" disabled id="txtNumFuncionariosSerasa" name="txtNumFuncionariosSerasa" class="form-control" placeholder="Número de Funcionários">
                                </div>
                              </div>

                              <div class="form-group col-lg-2 col-sm-12 col-xs-12">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtNIRESerasa">NIRE: </label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" disabled id="txtNIRESerasa" name="txtNIRESerasa" class="form-control" placeholder="NIRE">
                                </div>
                              </div>

                              <div class="form-group col-lg-2 col-sm-12 col-xs-12">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigoSerasa">Código Serasa: </label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" disabled id="txtCodigoSerasa" name="txtCodigoSerasa" class="form-control" placeholder="Código Serasa">
                                </div>
                              </div>

                              <div class="form-group col-lg-2 col-sm-12 col-xs-12">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtCNAESerasa">CNAE: </label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" disabled id="txtCNAESerasa" name="txtCNAESerasa" class="form-control" placeholder="CNAE">
                                </div>
                              </div>

                              <div class="form-group col-lg-2 col-sm-12 col-xs-12">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtNumFiliaisSerasa">Número de Filiais: </label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" disabled id="txtNumFiliaisSerasa" name="txtNumFiliaisSerasa" class="form-control" placeholder="Número de Filiais">
                                </div>
                              </div>

                              <div class="form-group col-lg-2 col-sm-12 col-xs-12">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtProbabilidadeInadimplenciaSerasa">Probabilidade de Inadinplencia: </label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" disabled id="txtProbabilidadeInadimplenciaSerasa" name="txtProbabilidadeInadimplenciaSerasa" class="form-control" placeholder="Probabilidade de Inadinplencia">
                                </div>
                              </div>

                              <div class="form-group col-lg-10 col-sm-12 col-xs-12">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtDescricaoScoreSerasa">Descrição Serasa Score: </label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" disabled id="txtDescricaoScoreSerasa" name="txtDescricaoScoreSerasa" class="form-control" placeholder="Descrição Serasa Score">
                                </div>
                              </div>


                            </div>

                            <h4>Informações sobre Sócios e Administradores</h4>

                            <div class="row" style="height: 100%;">
                              <div class="col-sm-12 table-responsive">
                                <table id="tabelaSocios" class="table table-sm table-select table-hover" width="100%">
                                  <thead>
                                  </thead>
                                  <tbody>
                                  </tbody>
                                </table>
                              </div>
                            </div>

                            <h4>Informações Administrativas</h4>

                            <div class="row" style="height: 100%;">
                              <div class="col-sm-12 table-responsive">
                                <table id="tabelaDiretores" class="table table-sm table-select table-hover" width="100%">
                                  <thead>
                                  </thead>
                                  <tbody>
                                  </tbody>
                                </table>
                              </div>
                            </div>

                            <h4>Consultas ao Serasa</h4>

                            <div class="row" style="height: 100%;">
                              <div class="col-sm-12 pt-2 d-flex justify-content-center align-items-center" style="height: 200px;">
                                <div id="graficoUltimasConsultas" style="width: 100%; height: 100%;"></div>
                              </div>

                              <div class="col-sm-12 table-responsive">
                                <table id="tabelaUltimasConsultas" class="table table-sm table-select table-hover" width="100%">
                                  <thead></thead>
                                  <tbody></tbody>
                                </table>
                              </div>
                            </div>

                          </div>
                        </fieldset>
                      </div>

                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  </div>


  <div class="modal fade bd-baixa-modal-xl" id="modalObservacao" tabindex="-1" role="dialog" aria-labelledby="ModalBaixa" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="BaixaModal">Observações</h5>
          <button type="button" class="close" id="CloseBaixa" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="container-fluid">
            <div class="card">
              <div class="card-body">
                <form id="msform" name="msform">

                  <div class="col-sm-12 table-responsive">
                    <table id="tabelaObservacoesReceber" class="table table-sm table-select table-hover" width="100%">
                      <thead>
                        <th>ID</th>
                        <th>OBS</th>
                        <th>MOTIVO</th>
                        <th>USUARIO</th>
                        <th>DATA</th>
                        <th>EMP_ID</th>
                      </thead>
                      <tbody>
                      </tbody>
                    </table>
                  </div>
                  <div class="modal-footer" class="d-flex">
                    <div class="d-flex">
                      <button class="btn bg-gradient-danger btn-sisp ml-auto" type="button" data-dismiss="modal" id="btnFecharObs">Fechar</button>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modal_obs">
    <div class="modal-dialog modal-xl" id="tammodal">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Observações </h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="container-fluid">
            <div class="form-row">
              <div class="col-sm-2">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtNumeroObs">Número:
                </label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtNumeroObs"
                    name="txtNumeroObs" placeholder="Numero" disabled data-selecionado="true">
                </div>
              </div>
              <div class="col-sm-3">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtClienteObs">Cliente:
                </label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtClienteObs"
                    name="txtClienteObs" placeholder="Cliente" disabled data-selecionado="true">
                </div>
              </div>

              <div class="col-sm-2">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtUsuarioObs">Usuário:
                </label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtUsuarioObs"
                    name="txtUsuarioObs" placeholder="Usuário" disabled data-selecionado="true">
                </div>
              </div>
              <div class="col-sm-2 ml-auto">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtDataObs">Data:</label>
                <div class="input-group">
                  <input type="date" class="input-default focus form-control" disabled id="txtDataObs" name="txtDataObs" placeholder="Data" data-selecionado="true">
                </div>
              </div>

              <div class="col-6 col-lg-3 form-group">
                <label data-error="wrong" data-success="right" for="txtMotivoObs">Motivo: *</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtMotivoObs" name="txtMotivoObs" class="form-control" placeholder="Motivo">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnMotivoObs" name="btnMotivoObs" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaMotivoObs" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <input type="text" id="txtIdObs" class="d-none">
            </div>
            <div class="form-row mt-1">
              <label for="inputObs" class="form-label">Observação:</label>
              <textarea class="form-control" id="txtObs" rows="14"
                style="resize: none"></textarea>
            </div>
          </div>
        </div>
        <div class="modal-footer" class="d-flex">
          <div class="d-flex">
            <button class="btn bg-gradient-danger btn-sisp ml-auto" data-dismiss="modal" id="btnFecharModalObsSerasa">Fechar</button>
            <button class="btn btn-sisp btn-primary ml-2" id="btnConfirmarObs">Gravar</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" data-backdrop="static" id="modal_consulta">
    <div class="modal-dialog modal-xl" id="tammodal">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Consultar Cliente </h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="col-sm-12 col-12" id="divCliente">
            <label data-error="wrong" class="mb-0" data-success="right" for="txtCliente">Cliente
            </label>
            <div class="input-group">
              <div class="input-group-append">
                <button class="btn bg-danger" id="btnCliente" name="btn-cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                <button class="btn bg-danger" id="btn-limpa-cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer" class="d-flex">
          <div class="d-flex">
            <button class="btn btn-sisp btn-primary ml-2" id="btnConsultarCliente">Consultar</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" data-backdrop="static" id="modal-referencias">
    <div class="modal-dialog modal-lg" id="tammodal">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title" id="tituloReferencias"> </h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <input class="d-none" type="text" id="txtClienteReferencia">
          <div class="row col-12">
            <div class="col-10">
              <label data-error="wrong" class="mb-0" data-success="right" for="txtClienteRef">Cliente </label>
              <div class="input-group">
                <input type="text" data-selecionado="false" class="input-default focus form-control clientFields" id="txtClienteRef" name="txtClienteRef" class="form-control" placeholder="Cliente">
                <div class="input-group-append">
                  <button class="btn bg-danger clientFields" id="btnClienteRef" name="btnClienteRef" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger clientFields" id="btnLimpaClienteRef" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-2 mt-3 pt-1">
              <button class="btn btn-sisp btn-primary ml-2" id="btnAdicionarClienteRef">Adicionar</button>
            </div>
          </div>
          <div class="col-12 mt-2" style="height: 385px;">
            <table id="tabelaCliRef" class="table table-select table-hover" width="100%">
              <thead>
              </thead>
              <tbody>
              </tbody>
            </table>
          </div>
        </div>
        <div class="modal-footer" class="d-flex">
          <div class="col-12 d-flex justify-content-between">
            <button class="btn btn-sisp btn-primary btnVerde ml-2" id="btnConfirmarClienteRef">Confirmar</button>
            <button class="btn btn-danger btn-sisp" id="btnDesistirClienteRef" data-dismiss="modal">Desistir</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <aside class="control-sidebar control-sidebar-dark">
  </aside>

  <script>
    function formatar(mascara, documento) {
      var i = documento.value.length;
      var saida = mascara.substring(0, 1);
      var texto = mascara.substring(i);

      if (texto.substring(0, 1) != saida) {
        documento.value += texto.substring(0, 1);
      }

    }
  </script>

  <?php
  include_once('../../modais.php');
  include_once('../../modals/modal_ocorrencias.html');
  include_once('../../../modals/modal_anexos.html');
  ?>

  <script src="./plugins/jquery/jquery.min.js?versao=3.2511.19.1"></script>
  <script src="./plugins/jquery-ui/jquery-ui.min.js?versao=3.2511.19.1"></script>
  <script type="text/javascript" src="./dist/js/jquery.dataTables.js?versao=3.2511.19.1"></script>
  <script type="text/javascript" src="./dist/js/dataTables.bootstrap4.min.js?versao=3.2511.19.1"></script>
  <script src="./plugins/sweetalert2/sweetalert2.min.js?versao=3.2511.19.1"></script>
  <script src="./plugins/toastr/toastr.min.js?versao=3.2511.19.1"></script>

  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>

  <script src="./plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2511.19.1"></script>
  <script src="./dist/js/adminlte.min.js?versao=3.2511.19.1"></script>
  <script src="./dist/js/requisicoes.js?versao=3.2511.19.1"></script>
  <script src="./dist/js/cliente/entidade.js?versao=3.2511.19.1"></script>
  <script src="./dist/js/loadingoverlay.min.js?versao=3.2511.19.1"></script>
  <script src="./plugins/jquery-validation/jquery.validate.min.js?versao=3.2511.19.1"></script>
  <script src="./dist/js/valida_cpf_cnpj.js?versao=3.2511.19.1"></script>
  <script src="./dist/js/dataTables.keyTable.js?versao=3.2511.19.1"></script>
  <script src="./dist/js/sisplan.js?versao=3.2511.19.1"></script>
  <script src="./utils/funcoes.js?versao=3.2511.19.1"></script>
  <script src="./graficos/graficos.js?versao=3.2511.19.1"></script>
  <script src="./utils/cookies.js?versao=3.2511.19.1"></script>
  <script src="./dist/js/driver.min.js?versao=3.2511.19.1"></script>
  <script src="./dist/js/jquery.mask.min.js?versao=3.2511.19.1"></script>
  <script src="./dist/js/jquery.maskMoney.min.js?versao=3.2511.19.1"></script>
  <script type="text/javascript" src="./config.js?versao=3.2511.19.1"></script>
  <script type="text/javascript" src="./modals/modal_estatisticas_entidade.js?versao=3.2511.19.1"></script>
  <script type="text/javascript" src="./modals/modal_cadcontato.js?versao=3.2511.19.1"></script>
  <script type="text/javascript" src="./modals/modal_ocorrencias.js?versao=3.2511.19.1"></script>
  <script type="text/javascript" src="./modals/modal_anexos.js?versao=3.2511.19.1"></script>
  <script src="./plugins/select2/js/select2.full.min.js?versao=3.2511.19.1"></script>
  <script src="./plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2511.19.1"></script>
  <script src="dist/js/datetime.js?versao=3.2511.19.1"></script>
  <script src="plugins/high-charts/highcharts.js"></script>
  <script src="plugins/high-charts/highcharts-more.js"></script>
  <script src="plugins/high-charts/solid-gauge.js"></script>

  <script src="plugins/high-charts/highcharts-3d.js"></script>
  <script src="plugins/high-charts/cylinder.js"></script>
  <script src="plugins/high-charts/exporting.js"></script>
  <script src="plugins/high-charts/export-data.js"></script>

  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('ANALISEFINAN');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      const permissaoUsuarioLogado = await permissaoAcessos("ANALISEFINAN");

      if (permissaoUsuarioLogado.INCLUI == 'N') {
        await criaMensagemErro("Sem permissão para incluir!", () => {
          window.location.href = `${BASE_URI}/cliente`
        });
        return;
      }

      const queryString = window.location.href;
      const parametros = queryString.split("/");
      const cliente = parametros[parametros.length - 1];

      $(window).on("beforeunload", function(e) {
        // e.preventDefault();
        e.stopPropagation();
        deletaRegistro("ANALISEFINAN", getCookie("usuario"), cliente);
        return undefined;
      });

      sArquivo = `${BASE_URI}/pages/analisefinanceira/analisefinanceira.js?versao=3.2511.19.1`;
      insereJavaScriptPagina(sArquivo);

      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      habilitaCamposObrigatoriosTela(nomeTela);

    });
  </script>
</body>

</html>